/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2494;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_5251;
import net.minecraft.class_6862;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.Util;

public class FloatToolStat
implements INumericToolStat<Float> {
    private final ToolStatId name;
    private final class_5251 color;
    private final float defaultValue;
    private final float minValue;
    private final float maxValue;
    @Nullable
    private final class_6862<class_1792> tag;

    public FloatToolStat(ToolStatId name, int color, float defaultValue, float minValue, float maxValue, @Nullable class_6862<class_1792> tag) {
        this.name = name;
        this.color = class_5251.method_27717((int)color);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.tag = tag;
    }

    public FloatToolStat(ToolStatId name, int color, float defaultValue, float minValue, float maxValue) {
        this(name, color, defaultValue, minValue, maxValue, null);
    }

    @Override
    public boolean supports(class_1792 item) {
        return this.tag == null || RegistryHelper.contains(this.tag, item);
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(this.defaultValue);
    }

    @Override
    public Float clamp(Float value) {
        return Float.valueOf(class_3532.method_15363((float)value.floatValue(), (float)this.getMinValue(), (float)this.getMaxValue()));
    }

    @Override
    public FloatBuilder makeBuilder() {
        return new FloatBuilder();
    }

    @Override
    public void add(ModifierStatsBuilder builder, double value) {
        builder.updateStat(this, b -> {
            b.add = (float)((double)b.add + value);
        });
    }

    @Override
    public void multiply(ModifierStatsBuilder builder, double factor) {
        builder.updateStat(this, b -> {
            b.multiply = (float)((double)b.multiply * factor);
        });
    }

    @Override
    public void multiplyAll(ModifierStatsBuilder builder, double factor) {
        builder.updateStat(this, b -> {
            b.multiply = (float)((double)b.multiply * factor);
        });
        builder.multiplier(this, factor);
    }

    @Override
    public Float build(Object builderObj, Float value) {
        FloatBuilder builder = (FloatBuilder)builderObj;
        return Float.valueOf((value.floatValue() + builder.add) * builder.multiply);
    }

    @Override
    @Nullable
    public Float read(class_2520 tag) {
        if (TagUtil.isNumeric(tag)) {
            return Float.valueOf(((class_2514)tag).method_10700());
        }
        return null;
    }

    @Override
    public class_2520 write(Float value) {
        return class_2494.method_23244((float)value.floatValue());
    }

    @Override
    public Float deserialize(JsonElement json) {
        return Float.valueOf(class_3518.method_15269((JsonElement)json, (String)this.getName().toString()));
    }

    @Override
    public JsonElement serialize(Float value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Float fromNetwork(class_2540 buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public void toNetwork(class_2540 buffer, Float value) {
        buffer.writeFloat(value.floatValue());
    }

    @Override
    public class_2561 formatValue(float value) {
        return IToolStat.formatNumber(Util.makeTranslationKey("tool_stat", this.getName()), this.getColor(), value);
    }

    public String toString() {
        return "FloatToolStat{" + this.name + "}";
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    public class_5251 getColor() {
        return this.color;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    protected static class FloatBuilder {
        private float add = 0.0f;
        private float multiply = 1.0f;
    }
}

